{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitFormFrequencia;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, UnitDadesGlobus2, MMSystem, StdCtrls, UnitMatematiques;

type
  TFormFrequencia = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    Panel1: TPanel;
    CheckBoxEvolucio: TCheckBox;
    CheckBoxEscalaLogaritmica: TCheckBox;
    StaticTextFrequenciaMouseMove: TStaticText;
    StaticTextNotaMouseMove: TStaticText;
    ImageFletxa: TImage;
    CheckBoxPosicioNotesMusicals: TCheckBox;
    ButtonIniciarMaximMinim: TButton;
    SpeedButtonCaixaEines: TSpeedButton;
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBoxEscalaLogaritmicaClick(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
    procedure CheckBoxPosicioNotesMusicalsClick(Sender: TObject);
    procedure ButtonIniciarMaximMinimClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButtonCaixaEinesClick(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
    ValorMaximDelSo:integer;
    UnitatEixX:LongInt;
    UnitatEixY:LongInt;
    FrequenciaAnterior:integer;
    Lineas:array[0..1000]of integer;
    PosicioLinea:integer;
    Sota:integer;
    ContadorFressa:integer;
    FrequenciaMaxima,FrequenciaMinima:integer;
    RelacioEnergies:single;
    ValorMinimDeSo:integer;
    procedure Pintar;
    function CalcularFrequencia:integer;
  end;

var
  FormFrequencia: TFormFrequencia;

{************************************************}
IMPLEMENTATION
{************************************************}

Uses UnitTools, UnitEntradaDeSo, UnitDades, UnitCalculsLPC, UnitCalculsMatematics,
  UnitCanviDeParametres, UnitFormPrincipal;

{$R *.DFM}

var
  Numeros:NumerosPerCalcular;

function potencia(base:single;exponent:integer):single;
var
  i:integer;
  Res:single;
begin
  if base=0 then begin
    potencia:=0;
  end else begin
    if exponent=0 then begin
      potencia:=1;
    end else if exponent=1 then begin
      potencia:=base;
    end else if exponent>1 then begin
      Res:=base;
      for i:=2 to exponent do res:=res*base;
      potencia:=res;
    end else if exponent=-1 then begin
      potencia:=1/base;
    end else begin
      Res:=1/base;
      for i:=2 to exponent do res:=res*(1/base);
      potencia:=res;
    end;
  end;
end;

function TFormFrequencia.CalcularFrequencia:integer;
var
  n,i:integer;
  NombreDeQuoeficients:integer;
  NumerosPerCalcularFFT,QuoeficientsFFTX,QuoeficientsFFTY,QuoeficientsFFTCosinus,QuoeficientsFFTSinus:NumerosPerCalcular;
  NombreDeQuoeficientsFFT:integer;
  IntervalXQuoeficientsFFT:single;
  NumerosPerCalcularQuoeficientsCepstrumPerFFT:NumerosPerCalcular;
  NombreDeQuoeficientsCepstrumPerFFT:integer;
  QuoeficientsCepstrumPerFFTX,QuoeficientsCepstrumPerFFTY,QuoeficientsCepstrumPerFFTCosinus,QuoeficientsCepstrumPerFFTSinus:NumerosPerCalcular;
  XCepstrumMaxim:integer;
  YCepstrumMaxim:single;
  FrequenciaCepstrum:integer;
  //DesviacioError:integer;
  NumerosEspectre:integer;
begin
  NombreDeQuoeficients:=512;
  if FrequenciaAnterior>=200 then NombreDeQuoeficients:=256;
  if FrequenciaDeMostreigEntradaSo=22050 then NombreDeQuoeficients:=2*NombreDeQuoeficients;
  if FrequenciaDeMostreigEntradaSo=44100 then NombreDeQuoeficients:=4*NombreDeQuoeficients;
  for n:=1 to NombreDeQuoeficients do NumerosPerCalcularFFT[n]:=Numeros[n];
  //for n:=1 to 256 do NumerosPerCalcularFFT[n]:=Numeros[n];
  //for n:=257 to 512 do NumerosPerCalcularFFT[n]:=0;
  CalcularFFT(true,true,false,false,false,true,true,200,255,NombreDeQuoeficients,NumerosPerCalcularFFT,NumerosEspectre,IntervalXQuoeficientsFFT,QuoeficientsFFTX,QuoeficientsFFTY,QuoeficientsFFTCosinus,QuoeficientsFFTSinus);
  RelacioEnergies:=CalcularRelacioEnergiesALInterval(NumerosEspectre,QuoeficientsFFTX,QuoeficientsFFTY);
  //if RelacioEnergies<50 then begin
  if RelacioEnergies<15 then begin
    CalcularFrequencia:=0;
    exit;
  end;
  CalcularFinestraDeHamming(NumerosPerCalcularFFT,NombreDeQuoeficients);
  CalcularQuoeficientsFFTY(NumerosPerCalcularFFT,NombreDeQuoeficients,NombreDeQuoeficientsFFT,IntervalXQuoeficientsFFT,QuoeficientsFFTX,QuoeficientsFFTY,QuoeficientsFFTCosinus,QuoeficientsFFTSinus);
  NormalitzarQuoeficientsPerMaxim(NombreDeQuoeficientsFFT,4,QuoeficientsFFTY);
  for n:=1 to NombreDeQuoeficients do NumerosPerCalcularQuoeficientsCepstrumPerFFT[n]:=QuoeficientsFFTY[n];
  CalcularElLogaritmeAlsQuoeficients(NombreDeQuoeficients,NumerosPerCalcularQuoeficientsCepstrumPerFFT);
  CalcularQuoeficientsCepstrumPerFFT(NombreDeQuoeficients,NumerosPerCalcularQuoeficientsCepstrumPerFFT,NombreDeQuoeficientsCepstrumPerFFT,QuoeficientsCepstrumPerFFTX,QuoeficientsCepstrumPerFFTY,QuoeficientsCepstrumPerFFTCosinus,QuoeficientsCepstrumPerFFTSinus);
  XCepstrumMaxim:=0;
  YCepstrumMaxim:=0;
  for n:=2 to NombreDeQuoeficientsCepstrumPerFFT do begin
    //if PeriodeAFrequencia(QuoeficientsCepstrumPerFFTX[n])<FrequenciaMaximaACalcular then begin
    if (PeriodeAFrequencia(QuoeficientsCepstrumPerFFTX[n])<800) then begin
      if QuoeficientsCepstrumPerFFTCosinus[n]>YCepstrumMaxim then begin
        XCepstrumMaxim:=Round(QuoeficientsCepstrumPerFFTX[n]);
        YCepstrumMaxim:=QuoeficientsCepstrumPerFFTCosinus[n];
      end;
    end;
  end;
  FrequenciaCepstrum:=Round(PeriodeAFrequencia(XCepstrumMaxim));
  if FrequenciaCepstrum>=50 then begin
    //Per controlar errors de clcul de freqncia degut als armnics
    {
    // Versi Globus 33
    if (FrequenciaCepstrum*2+5>FrequenciaAnterior) and (FrequenciaCepstrum*2-5<FrequenciaAnterior) then FrequenciaCepstrum:=FrequenciaAnterior;
    }
    // Versi Globus 49
    for i:=2 to 8 do begin
      //if (FrequenciaCepstrum*i+DesviacioError>FrequenciaAnterior) and (FrequenciaCepstrum*i-DesviacioError<FrequenciaAnterior) then begin
      if (FrequenciaCepstrum*i*1.15>FrequenciaAnterior) and (FrequenciaCepstrum*i*0.85<FrequenciaAnterior) then begin
        FrequenciaCepstrum:=FrequenciaCepstrum*i;
        break;
      end;
      if (FrequenciaCepstrum<FrequenciaAnterior*i*1.15) and (FrequenciaCepstrum>FrequenciaAnterior*i*0.85) then begin
        FrequenciaCepstrum:=Round(FrequenciaCepstrum/i);
        break;
      end;
    end;

    //if (FrequenciaCepstrum*2*1.1>FrequenciaAnterior) and (FrequenciaCepstrum*2*0.9<FrequenciaAnterior) then FrequenciaCepstrum:=FrequenciaCepstrum*2;

    CalcularFrequencia:=FrequenciaCepstrum;
  end else begin
    CalcularFrequencia:=0;
  end;
end;

{************************************************}
procedure TFormFrequencia.FormCreate(Sender: TObject);
begin
  FrequenciaAnterior:=0;
  ContadorFressa:=0;
  FrequenciaMaxima:=0;
  FrequenciaMinima:=10000;
  ValorMinimDeSo:=15*256;
end;

procedure TFormFrequencia.FormPaint(Sender: TObject);
begin
  Pintar;
end;

procedure TFormFrequencia.FormResize(Sender: TObject);
begin
  Repaint;
end;

procedure TFormFrequencia.SpeedButtonEngegarPararClick(Sender: TObject);
var
  i:integer;
begin
   if SpeedButtonEngegarParar.Down then begin
    IniciarDadesEntradaDeSo;
    //128-256-512-1024-2048
    GrandariaBytesBufferEntradaDeSo:=512;
    //GrandariaBytesBufferEntradaDeSo:=1024;
    //8-16
    BitsPerMostraEntradaSo:=16;
    //11025-22050-44100
    FrequenciaDeMostreigEntradaSo:=11025;
    //FrequenciaDeMostreigEntradaSo:=22050;
    for i:=0 to 1000 do Lineas[i]:=0;
    PosicioLinea:=0;
    Repaint;
    CheckBoxEScalaLogaritmica.Enabled:=false;
    CheckBoxPosicioNotesMusicals.Enabled:=false;
    FrequenciaAnterior:=0;
    FrequenciaMaxima:=0;
    FrequenciaMinima:=10000;
    ValorMinimDeSo:=StrToInt(FormCanviDeParametres.EditMinim.Text)*256;
    if EngegarProcesEntradaDeSo(Handle)=0 then SpeedButtonEngegarParar.Caption:='P';
  end else begin
    //PararEntradaDeSo;
    FinalitzarEntradaDeSo;
    SpeedButtonEngegarParar.Caption:='E';
    CheckBoxEScalaLogaritmica.Enabled:=true;
    CheckBoxPosicioNotesMusicals.Enabled:=true;
  end;
end;

procedure TFormFrequencia.FormClose(Sender: TObject;var Action: TCloseAction);
begin
  if SpeedButtonEngegarParar.Down then begin
    //PararEntradaSo;
    FinalitzarEntradaDeSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
    SpeedButtonEngegarParar.Enabled:=true;
    //SpeedButtonEngegarPararGlobus.Caption:='EG';
    //SpeedButtonEngegarPararGlobus.Down:=false;
    //SpeedButtonEngegarPararGlobus.Enabled:=true;
  end;
end;

procedure TFormFrequencia.WMWIMDATA(var Msg: TMessage);
var
  i:integer;
begin
  if ParoProcesContinuEntradaDeSo then exit;
  ValorMaximDelSo:=ValorMaximDetectatEntradaDeSo;
  for i:=1 to GrandariaNumerosBufferEntradaDeSo do Numeros[i]:=NumerosEntradaDeSo[i];
  //if ValorMaximDelSo>15*256 then begin
  if ValorMaximDelSo>ValorMinimDeSo then begin
    if ContadorFressa<2 then inc(ContadorFressa);
  end else begin
    FrequenciaAnterior:=0;
    ContadorFressa:=0;
    ImageFletxa.Visible:=false;
    if PosicioLinea<600 then begin
      inc(PosicioLinea);
      Lineas[PosicioLinea]:=0;
    end;
  end;
  if ContadorFressa>1 then Pintar;
end;

procedure TFormFrequencia.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

procedure TFormFrequencia.Pintar;
var
  n,i:integer;
  FrequenciaCepstrum:integer;
  FrequenciaNota:single;
  Co,Co1,Co2,Co3:integer;
  Rect:TRect;
  PosicioFletxa:integer;
  FrequenciaNotaMusical:single;
begin
  Sota:=ClientHeight-40;

  //if ValorMaximDelSo>15*256 then begin
  if ValorMaximDelSo>ValorMinimDeSo then begin
    Canvas.Pen.Color:=clWhite;
    Canvas.Brush.Color:=clWhite;
    Rect.Left:=33;
    Rect.Top:=0;
    Rect.Right:=44;
    Rect.Bottom:=Sota;
    Canvas.FillRect(Rect);
  end;

  Canvas.Pen.Color:=clGray;
  Canvas.Font.Color:=clGray;
  Canvas.MoveTo(50,Sota);
  Canvas.LineTo(50,0);
  if CheckBoxEScalaLogaritmica.Checked then begin
    for n:=0 to 7 do begin
      Canvas.MoveTo(45,Sota-n*100);
      Canvas.LineTo(Width,Sota-n*100);
      Canvas.textOut(25,Sota-n*100-4,IntToStr(50*Round(potencia(2,n))));
    end;

    //Dibuixar el piano
    FrequenciaNota:=55;
    Co:=Round(ln(FrequenciaNota/50)/ln(2)*100);
    Co1:=24;
    //Co3:=Round(100/14);
    Co3:=Round(100/8);
    Canvas.Pen.Color:=clBlack;
    Canvas.MoveTo(Co1,0);
    Canvas.LineTo(Co1,Sota-Co+Co3);
    for i:=0 to 47 do begin
      Co2:=i mod 7;
      if (Co2=2) then Canvas.Pen.Color:=clBlack else Canvas.Pen.Color:=clGray;
      Canvas.MoveTo(0,Sota-Co-Round(i*100/7)+Co3);
      Canvas.LineTo(Co1,Sota-Co-Round(i*100/7)+Co3);
    end;
    Canvas.Pen.Color:=clGray;
    Canvas.Brush.Color:=clGray;
    Co1:=15;
    for i:=0 to 47 do begin
      Co2:=i mod 7;
      if (Co2=0) or (Co2=1) or (Co2=3) or (Co2=4) or (Co2=6) then begin
        Rect.Left:=0;
        Rect.Top:=Sota-Co-Round(i*100/7+100/24)+Co3;
        Rect.Right:=Co1;
        Rect.Bottom:=Sota-Co-Round(i*100/7-100/24)+Co3;
        Canvas.FillRect(Rect);
      end;
    end;
    Canvas.Pen.Color:=clGray;
    Canvas.Brush.Color:=clWhite;
    //Fi Dibuixar el piano

  end else begin
    for n:=0 to 6 do begin
      Canvas.MoveTo(45,Sota-n*100);
      Canvas.LineTo(Width,Sota-n*100);
      Canvas.textOut(25,Sota-n*100-4,IntToStr(n*100));
    end;
  end;
  //if ValorMaximDelSo>15*256 then begin
  if ValorMaximDelSo>ValorMinimDeSo then begin
    FrequenciaCepstrum:=CalcularFrequencia;
    if FrequenciaCepstrum>=50 then begin
      if FrequenciaMaxima<FrequenciaCepstrum then FrequenciaMaxima:=FrequenciaCepstrum;
      if FrequenciaMinima>FrequenciaCepstrum then FrequenciaMinima:=FrequenciaCepstrum;
      {
      if FrequenciaMaxima>0 then begin
        if CheckBoxPosicioNotesMusicals.Checked then begin
          FrequenciaMaxima:=Round(TornarFrequenciaNotaMusical(FrequenciaMaxima));
          FrequenciaMinima:=Round(TornarFrequenciaNotaMusical(FrequenciaMinima));
        end;
        Canvas.Pen.Color:=clRed;
        if CheckBoxEScalaLogaritmica.Checked then begin
          Canvas.MoveTo(43,Sota-Round(ln(FrequenciaMaxima/50)/ln(2)*100));
          Canvas.LineTo(33,Sota-Round(ln(FrequenciaMaxima/50)/ln(2)*100));
          Canvas.MoveTo(43,Sota-Round(ln(FrequenciaMinima/50)/ln(2)*100));
          Canvas.LineTo(33,Sota-Round(ln(FrequenciaMinima/50)/ln(2)*100));
        end else begin
          Canvas.MoveTo(43,Sota-FrequenciaMaxima);
          Canvas.LineTo(33,Sota-FrequenciaMaxima);
          Canvas.MoveTo(43,Sota-FrequenciaMinima);
          Canvas.LineTo(33,Sota-FrequenciaMinima);
        end;
      end;
      }
      //Canvas.Pen.Color:=clBlack;
      if CheckBoxPosicioNotesMusicals.Checked then begin
        FrequenciaNotaMusical:=TornarFrequenciaNotaMusical(FrequenciaCepstrum);
        PosicioFletxa:=Round(FrequenciaNotaMusical);
        if CheckBoxEScalaLogaritmica.Checked then PosicioFletxa:=Round(ln(FrequenciaNotaMusical/50)/ln(2)*100);
      end else begin
        PosicioFletxa:=FrequenciaCepstrum;
        if CheckBoxEScalaLogaritmica.Checked then PosicioFletxa:=Round(ln(FrequenciaCepstrum/50)/ln(2)*100);
      end;
      FrequenciaAnterior:=FrequenciaCepstrum;
      ImageFletxa.Top:=Sota-PosicioFletxa-15;
      ImageFletxa.Left:=50;
      ImageFletxa.Visible:=True;
      //Caption:=FormPrincipal.MenuFrequencia.Caption+': '+IntToStr(FrequenciaCepstrum)+ ' | '+TornarNota(FrequenciaCepstrum)+ ' | '+ FloatToStr(RelacioEnergies);
      Caption:=FormPrincipal.MenuFrequencia.Caption+': '+IntToStr(FrequenciaCepstrum)+ ' | '+TornarNota(FrequenciaCepstrum);
    end else begin
      ImageFletxa.Visible:=false;
      FrequenciaCepstrum:=0;
      PosicioFletxa:=0;
      //Caption:=FormPrincipal.MenuFrequencia.Caption+' | '+FloatToStr(RelacioEnergies);
      Caption:=FormPrincipal.MenuFrequencia.Caption;
    end;
  end else begin
    ImageFletxa.Visible:=false;
    FrequenciaCepstrum:=0;
    PosicioFletxa:=0;
    Caption:=FormPrincipal.MenuFrequencia.Caption;
  end;
  if CheckBoxEvolucio.Checked then begin
    if CheckBoxPosicioNotesMusicals.Checked then begin
      if (PosicioLinea<600) and SpeedButtonEngegarParar.Down then begin
        inc(PosicioLinea);
        Lineas[PosicioLinea]:=PosicioFletxa;
      end;
      Canvas.Pen.Color:=clRed;
      for n:=0 to PosicioLinea do begin
        Canvas.MoveTo(50+n-1,Sota-Lineas[n]);
        Canvas.LineTo(50+n,Sota-Lineas[n]);
      end;
    end else begin
      if (PosicioLinea<600) and SpeedButtonEngegarParar.Down then begin
        inc(PosicioLinea);
        Lineas[PosicioLinea]:=FrequenciaCepstrum;
      end;
      Canvas.Pen.Color:=clRed;
      Canvas.MoveTo(50,Sota-Lineas[0]);
      for n:=0 to PosicioLinea do Canvas.LineTo(50+n,Sota-Lineas[n]);
    end;
  end;
  //if FrequenciaCepstrum>=50 then begin
    if FrequenciaMaxima>0 then begin
      if CheckBoxPosicioNotesMusicals.Checked then begin
        FrequenciaMaxima:=Round(TornarFrequenciaNotaMusical(FrequenciaMaxima));
        FrequenciaMinima:=Round(TornarFrequenciaNotaMusical(FrequenciaMinima));
      end;
      Canvas.Pen.Color:=clRed;
      if CheckBoxEScalaLogaritmica.Checked then begin
        Canvas.MoveTo(43,Sota-Round(ln(FrequenciaMaxima/50)/ln(2)*100));
        Canvas.LineTo(33,Sota-Round(ln(FrequenciaMaxima/50)/ln(2)*100));
        Canvas.MoveTo(43,Sota-Round(ln(FrequenciaMinima/50)/ln(2)*100));
        Canvas.LineTo(33,Sota-Round(ln(FrequenciaMinima/50)/ln(2)*100));
      end else begin
        Canvas.MoveTo(43,Sota-FrequenciaMaxima);
        Canvas.LineTo(33,Sota-FrequenciaMaxima);
        Canvas.MoveTo(43,Sota-FrequenciaMinima);
        Canvas.LineTo(33,Sota-FrequenciaMinima);
      end;
    end;
  //end;
end;

procedure TFormFrequencia.CheckBoxEscalaLogaritmicaClick(Sender: TObject);
var
  i:integer;
begin
  for i:=0 to 1000 do Lineas[i]:=0;
  PosicioLinea:=0;
  Repaint;
end;

procedure TFormFrequencia.FormMouseMove(Sender: TObject;Shift: TShiftState; X, Y: Integer);
var
  Freq:integer;
begin
  if y<=Sota then begin
    if CheckBoxEScalaLogaritmica.Checked then begin
      Freq:=Round(50*(exp(((Sota-y)/100)*ln(2))));
    end else begin
      Freq:=(Sota-y);
    end;
    StaticTextFrequenciaMouseMove.Caption:=IntToStr(Freq)+'  Hz';
    StaticTextNotaMouseMove.Caption:=TornarNota(Freq);
  end;
end;

procedure TFormFrequencia.CheckBoxPosicioNotesMusicalsClick(Sender: TObject);
begin
  Repaint;
end;

procedure TFormFrequencia.ButtonIniciarMaximMinimClick(Sender: TObject);
begin
  FrequenciaMaxima:=0;
  FrequenciaMinima:=10000;
  FrequenciaAnterior:=0;
  Repaint;
end;


procedure TFormFrequencia.SpeedButtonCaixaEinesClick(Sender: TObject);
begin
  FormCanviDeParametres.ShowModal;
end;

procedure TFormFrequencia.FormMouseDown(Sender: TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbleft then begin
  end else begin
    if SpeedButtonEngegarParar.Down then begin
      FinalitzarEntradaDeSo;
      SpeedButtonEngegarParar.Caption:='E';
      SpeedButtonEngegarParar.Down:=false;
      SpeedButtonEngegarParar.Enabled:=true;
    end;
  end;
end;

end.
